#include <usb_config.h>
#include <usb.h>
#include <usb_device_hid.h>

typedef struct __attribute__((packed))
{
    unsigned :8;
    unsigned :8;
    uint8_t reportId;
    uint8_t duration;
} USB_SETUP_SET_IDLE_RATE;

typedef struct __attribute__((packed))
{
    unsigned :8;
    unsigned :8;
    uint8_t protocol;
} USB_SETUP_SET_PROTOCOL;

static uint8_t idle_rate;
static uint8_t active_protocol;  

extern const struct{uint8_t report[HID_RPT01_SIZE];}hid_rpt01;

#if defined USER_GET_REPORT_HANDLER
    void USER_GET_REPORT_HANDLER(void);
#endif

#if defined USER_SET_REPORT_HANDLER
    extern void USER_SET_REPORT_HANDLER(void);
#endif     

#ifndef USB_DEVICE_HID_IDLE_RATE_CALLBACK
    #define USB_DEVICE_HID_IDLE_RATE_CALLBACK(reportId, idleRate)
#else
    extern void USB_DEVICE_HID_IDLE_RATE_CALLBACK(uint8_t reportId, uint8_t idleRate);
#endif

void USBCheckHIDRequest(void)
{
    if(SetupPkt.Recipient != USB_SETUP_RECIPIENT_INTERFACE_BITFIELD) return;
    if(SetupPkt.bIntfID != HID_INTF_ID) return;

    if(SetupPkt.bRequest == USB_REQUEST_GET_DESCRIPTOR)
    {
        switch(SetupPkt.bDescriptorType)
        {
            case DSC_HID:     
                if(USBActiveConfiguration == 1)
                {
                    USBEP0SendROMPtr(
                        (const uint8_t*)&configDescriptor1 + 18,		
                        sizeof(USB_HID_DSC)+3,
                        USB_EP0_INCLUDE_ZERO);
                }
                break;
            case DSC_RPT:           
                {
                    USBEP0SendROMPtr(
                        (const uint8_t*)&hid_rpt01,
                        HID_RPT01_SIZE,     //See usbcfg.h
                        USB_EP0_INCLUDE_ZERO);
                }
                break;
            case DSC_PHY:  
                break;
        }
    }
    
    if(SetupPkt.RequestType != USB_SETUP_TYPE_CLASS_BITFIELD)
    {
        return;
    }

    switch(SetupPkt.bRequest)
    {
        case GET_REPORT:
            #if defined USER_GET_REPORT_HANDLER
                USER_GET_REPORT_HANDLER();
            #endif
            break;
        case SET_REPORT:
            #if defined USER_SET_REPORT_HANDLER
                USER_SET_REPORT_HANDLER();
            #endif       
            break;
        case GET_IDLE:
            USBEP0SendRAMPtr(
                (uint8_t*)&idle_rate,
                1,
                USB_EP0_INCLUDE_ZERO);
            break;
        case SET_IDLE:
            USBEP0Transmit(USB_EP0_NO_DATA);
            idle_rate = ((USB_SETUP_SET_IDLE_RATE*)&SetupPkt)->duration;
            USB_DEVICE_HID_IDLE_RATE_CALLBACK(((USB_SETUP_SET_IDLE_RATE*)&SetupPkt)->reportId, idle_rate);
            break;
        case GET_PROTOCOL:
            USBEP0SendRAMPtr(
                (uint8_t*)&active_protocol,
                1,
                USB_EP0_NO_OPTIONS);
            break;
        case SET_PROTOCOL:
            USBEP0Transmit(USB_EP0_NO_DATA);
            active_protocol = ((USB_SETUP_SET_PROTOCOL*)&SetupPkt)->protocol;
            break;
    }
}

